﻿Module Engine

    Public Structure DadosLinguagem
        Dim InRacioCalculado As String
        Dim InRacioNormal As String
        Dim InCaptura_Activar As String
        Dim InCaptura_Desactivar As String
        Dim ContextMenu_Desactivar As String
        Dim ContextMenu_Activar As String
        Dim MsgBoxArea_1 As String
        Dim MsgBoxArea_2 As String
        Dim MsgBoxArea_3 As String
        Dim InMenCapturaLocalizada As String
        Dim InMenCapturaTemporizada As String
        Dim InMenCaptura As String
        Dim GroupBox3 As String
        Dim Label3 As String
        Dim Label1 As String
        Dim GroupBox4 As String
        Dim label6 As String
        Dim GroupBox2 As String
        Dim RadioButton1 As String
        Dim RadioButton2 As String
        Dim Checkbox1 As String
        Dim Groupbox5 As String
        Dim Button4 As String
        Dim Radiobutton6 As String
        Dim RadioButton5 As String
        Dim RadioButton7 As String
        Dim RadioButton8 As String
        Dim Label7 As String
        Dim ProductName As String
        Dim Versao As String
        Dim Descricao As String
        Dim GroupBox6 As String
        Dim Label8 As String
        Dim MsgboxTime As String
        Dim MsgboxContador As String
        Dim Button6 As String
        Dim MsgboxPixeis As String
        Dim MsgboxPrefixo As String
        Dim MsgboxActivada As String
        Dim Msgbox3El As String
        Dim MsgboxElemento1 As String
        Dim MsgboxElemento2 As String
        Dim MsgboxElemento3 As String
        Dim MsgboxErroLogin As String
        Dim Checkbox2 As String
        Dim Checkbox3 As String
        Dim Checkbox4 As String
        Dim Label9 As String
        Dim Label10 As String
        Dim Label11 As String
    End Structure

    Public AreaIndicada As Rectangle
    Public DLinguagem As New DadosLinguagem

    Public Sub ObterLinguagens(ByVal Combo As ToolStripComboBox)
        Dim Caminho As String = Application.StartupPath & "\Linguagens\"

        Combo.Items.Clear()

        Dim i As Integer
        For i = 0 To My.Computer.FileSystem.GetFiles(Caminho).Count - 1
            Dim Nome As String = My.Computer.FileSystem.GetFileInfo(My.Computer.FileSystem.GetFiles(Caminho).Item(i)).Name
            Dim Tx() As String = Split(Nome, ".")
            Nome = Tx(0)

            Combo.Items.Add(Nome)
        Next
    End Sub

    Public Sub LoadLanguage(ByVal NomeLinguagem As String)
        Dim Caminho As String = Application.StartupPath & "\Linguagens\" & NomeLinguagem & ".xml"

        Dim Root As XElement = XElement.Load(Caminho)

        For Each El As XElement In Root.Elements
            Select Case El.Name.ToString
                Case "InRacioCalculado" : DLinguagem.InRacioCalculado = El.Value
                Case "InRacioNormal" : DLinguagem.InRacioNormal = El.Value
                Case "InCaptura_Activar" : DLinguagem.InCaptura_Activar = El.Value
                Case "InCaptura_Desactivar" : DLinguagem.InCaptura_Desactivar = El.Value
                Case "ContextMenu_Desactivar" : DLinguagem.ContextMenu_Desactivar = El.Value
                Case "ContextMenu_Activar" : DLinguagem.ContextMenu_Activar = El.Value
                Case "MsgBoxArea_1" : DLinguagem.MsgBoxArea_1 = El.Value
                Case "MsgBoxArea_2" : DLinguagem.MsgBoxArea_2 = El.Value
                Case "MsgBoxArea_3" : DLinguagem.MsgBoxArea_3 = El.Value
                Case "InMenCapturaLocalizada" : DLinguagem.InMenCapturaLocalizada = El.Value
                Case "InMenCapturaTemporizada" : DLinguagem.InMenCapturaTemporizada = El.Value
                Case "InMenCaptura" : DLinguagem.InMenCaptura = El.Value
                Case "GroupBox3" : DLinguagem.GroupBox3 = El.Value
                Case "Label3" : DLinguagem.Label3 = El.Value
                Case "Label1" : DLinguagem.Label1 = El.Value
                Case "GroupBox4" : DLinguagem.GroupBox4 = El.Value
                Case "label6" : DLinguagem.label6 = El.Value
                Case "GroupBox2" : DLinguagem.GroupBox2 = El.Value
                Case "RadioButton1" : DLinguagem.RadioButton1 = El.Value
                Case "RadioButton2" : DLinguagem.RadioButton2 = El.Value
                Case "Checkbox1" : DLinguagem.Checkbox1 = El.Value
                Case "Groupbox5" : DLinguagem.Groupbox5 = El.Value
                Case "Button4" : DLinguagem.Button4 = El.Value
                Case "Radiobutton6" : DLinguagem.Radiobutton6 = El.Value
                Case "RadioButton5" : DLinguagem.RadioButton5 = El.Value
                Case "RadioButton7" : DLinguagem.RadioButton7 = El.Value
                Case "RadioButton8" : DLinguagem.RadioButton8 = El.Value
                Case "Label7" : DLinguagem.Label7 = El.Value
                Case "ProductName" : DLinguagem.ProductName = El.Value
                Case "Versao" : DLinguagem.Versao = El.Value
                Case "Descricao" : DLinguagem.Descricao = El.Value
                Case "GroupBox6" : DLinguagem.GroupBox6 = El.Value
                Case "Label8" : DLinguagem.Label8 = El.Value
                Case "MsgboxTime" : DLinguagem.MsgboxTime = El.Value
                Case "MsgboxContador" : DLinguagem.MsgboxContador = El.Value
                Case "Button6" : DLinguagem.Button6 = El.Value
                Case "MsgboxPixeis" : DLinguagem.MsgboxPixeis = El.Value
                Case "MsgboxPrefixo" : DLinguagem.MsgboxPrefixo = El.Value
                Case "MsgboxActivada" : DLinguagem.MsgboxActivada = El.Value
                Case "Msgbox3El" : DLinguagem.Msgbox3El = El.Value
                Case "MsgboxElemento1" : DLinguagem.MsgboxElemento1 = El.Value
                Case "MsgboxElemento2" : DLinguagem.MsgboxElemento2 = El.Value
                Case "MsgboxElemento3" : DLinguagem.MsgboxElemento3 = El.Value
                Case "MsgboxErroLogin" : DLinguagem.MsgboxErroLogin = El.Value
                Case "Checkbox2" : DLinguagem.Checkbox2 = El.Value
                Case "Checkbox3" : DLinguagem.Checkbox3 = El.Value
                Case "Checkbox4" : DLinguagem.Checkbox4 = El.Value
                Case "Label9" : DLinguagem.Label9 = El.Value
                Case "Label10" : DLinguagem.Label10 = El.Value
                Case "Label11" : DLinguagem.Label11 = El.Value
            End Select
        Next
    End Sub

    ''' <summary>
    ''' Converte a imagem para jpg e grava a imagem
    ''' </summary>
    Public Function ConvertImage(ByVal SourceImage As Bitmap, ByVal SavePath As String)
        Try
            'Define o parametro de index 1 que determina o tipo de codec a usar
            Dim Parametros As Imaging.EncoderParameters = New Imaging.EncoderParameters(1) '1 = JPG

            'Instancia Qualidade como Parametro do Encoder dando um valor ao imaging.encoder.quality
            Dim Qualidade As Imaging.EncoderParameter = New Imaging.EncoderParameter(System.Drawing.Imaging.Encoder.Quality, 90)

            'Instancia um Codec com a informação de codecs dada por a função GetImageEncoders
            Dim Codec() As Imaging.ImageCodecInfo = Imaging.ImageCodecInfo.GetImageEncoders()

            'acrescenta nos parametros, em indice 0, o valor da qualidade
            Parametros.Param(0) = Qualidade

            'por fim, grava a imagem no destino dado, codec pretendido (1=JPG) e com os parametros para a qualidade certos
            SourceImage.Save(SavePath, Codec(1), Parametros)
        Catch ex As Exception
            Return 1
        End Try

        Return 0
    End Function

    ''' <summary>
    ''' Devolve a imagem com o novo tamanho
    ''' </summary>
    ''' <param name="Width">Largura com que a imagem tem que ficar</param>
    ''' <param name="Height">Altura com que a imagem tem que ficar</param>
    ''' <param name="SourceImage">A imagem original para ser alterado o tamanho</param>
    Public Function GetImageResized(ByVal Width As Integer, ByVal Height As Integer, _
    ByVal SourceImage As Bitmap) As Bitmap

        Dim NovoTamanho As New Rectangle                'Variavel de rectangulo para guardar o novo tamanho

        With NovoTamanho
            .X = 0
            .Y = 0

            If Width > -1 Then                  'Se houver uma nova largura
                .Width = Width                  'Guarda esse valor
            Else
                .Width = SourceImage.Width      'Senão mantem o valor anterior
            End If

            If Height > -1 Then                 'Se houver uma nova altura
                .Height = Height                'Guarda esse valor
            Else
                .Height = SourceImage.Height    'Senão mantem o valor anterior
            End If

        End With

        Dim Bmp As New Bitmap(NovoTamanho.Width, NovoTamanho.Height)   'Cria um bitmap com a nova altura e largura
        Dim G As Graphics = Graphics.FromImage(Bmp)                    'Cria uma variavel de desenho

        G.InterpolationMode = Drawing2D.InterpolationMode.HighQualityBicubic
        G.DrawImage(SourceImage, NovoTamanho, New Rectangle(0, 0, SourceImage.Width, SourceImage.Height), _
                    GraphicsUnit.Pixel)

        Return Bmp
    End Function

    ''' <summary>
    ''' Devolve uma imagem da area seleccionada
    ''' </summary>
    ''' <param name="AreaInfo">O rectangulo com os valores da area da imagem</param>
    Public Function ObterImagem(ByVal AreaInfo As Rectangle, ByVal Fr As Form) As Bitmap

        Dim St As New Stopwatch

        If Fr IsNot Nothing Then Fr.Hide()

        St.Start()
        While Not St.ElapsedMilliseconds = 100
            Application.DoEvents()
        End While

        'Cria um bitmap com o tamanho indicado
        If AreaInfo.Width < 0 Or AreaInfo.Height < 0 Then
            MsgBox("Area inválida")
            Return Nothing
        End If

        If AreaInfo.Height = 0 And AreaInfo.Height = 0 Then
            MsgBox("Area inválida")
            Return Nothing
        End If

        Dim screenGrab As New Bitmap(AreaInfo.Width, AreaInfo.Height)

        'Cria uma variavel de desenho que vai mexer no bitmap
        Dim g As Graphics = Graphics.FromImage(screenGrab)

        'Largura e altura da imagem a ir buscarno ecran
        Dim screenSize As Size = New Size(AreaInfo.Width, AreaInfo.Height)

        'Tira um screenshot do ponto areainfo.x,areainfo.y ate a altura e largura indicada no screensize
        g.CopyFromScreen(New Point(AreaInfo.X, AreaInfo.Y), New Point(0, 0), screenSize)

        If Fr IsNot Nothing Then Fr.Show()
        Return screenGrab
    End Function

    Public Function ObterImagemAlterada(ByVal Bmp As Bitmap) As Image
        Dim Imagem As New Bitmap(AreaIndicada.Width, AreaIndicada.Height, Imaging.PixelFormat.Format24bppRgb)
        Dim G As Graphics = Graphics.FromImage(Imagem)


        G.DrawImage(Bmp, New Rectangle(0, 0, Imagem.Width, Imagem.Height), AreaIndicada, GraphicsUnit.Pixel)
        G.Dispose()

        Return Imagem
    End Function

    Public Function DesenharBorder(ByVal Bmp As Bitmap) As Image
        Dim G As Graphics = Graphics.FromImage(Bmp)
        G.DrawRectangle(Pens.Black, 0, 0, Bmp.Width - 1, Bmp.Height - 1)

        Return Bmp
    End Function

    Public Sub UploadFicheiroParaFtp(ByVal FtpHost As String, ByVal UserName As String, ByVal Password As String, _
                                     ByVal FileToUpload As String, ByVal FileNameToCreate As String, ByVal DeleteFile As Boolean)

        Dim Rq As System.Net.FtpWebRequest = _
               DirectCast(System.Net.WebRequest.Create(FtpHost & "/" & FileNameToCreate), System.Net.FtpWebRequest)

        Rq.Credentials = New System.Net.NetworkCredential(UserName, Password)
        Rq.Method = System.Net.WebRequestMethods.Ftp.UploadFile

        Dim OFicheiro() As Byte = System.IO.File.ReadAllBytes(FileToUpload)

        Try
            Dim Sstream As System.IO.Stream = Rq.GetRequestStream

            Sstream.Write(OFicheiro, 0, OFicheiro.Length)
            Sstream.Close()
            Sstream.Dispose()

            If DeleteFile = True Then
                Try
                    My.Computer.FileSystem.DeleteFile(FileToUpload)
                Catch ex As Exception

                End Try
            End If
        Catch ex As Exception
            If ex.Message.Contains("530") = True Then
                MsgBox(DLinguagem.MsgboxErroLogin)
            Else
                MsgBox(ex.Message)
            End If
        End Try
    End Sub

End Module
